/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.core.DisplayDevice;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class FontSizeProperty
extends AbstractProperty {
    private static final float DEFAULT_FONT_SIZE_POINTS = 12.0f;
    private static final float FONT_SIZE_FACTOR = 1.2f;
    private static final float FONT_FACTOR_MEDIUM = 1.0f;
    private static final float FONT_FACTOR_SMALL = 0.8333333f;
    private static final float FONT_FACTOR_X_SMALL = 0.6944444f;
    private static final float FONT_FACTOR_XX_SMALL = 0.57870364f;
    private static final float FONT_FACTOR_LARGE = 1.2f;
    private static final float FONT_FACTOR_X_LARGE = 1.44f;
    private static final float FONT_FACTOR_XX_LARGE = 1.7280002f;

    public FontSizeProperty() {
        super("font-size");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        return new Float(this.calculateInternal(lu, parentStyles, styles));
    }

    public static boolean isFontSize(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (FontSizeProperty.isLength(lu)) {
            return true;
        }
        if (FontSizeProperty.isPercentage(lu)) {
            return true;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("xx-small") || s.equalsIgnoreCase("x-small") || s.equalsIgnoreCase("small") || s.equalsIgnoreCase("medium") || s.equalsIgnoreCase("large") || s.equalsIgnoreCase("x-large") || s.equalsIgnoreCase("xx-large") || s.equalsIgnoreCase("smaller") || s.equalsIgnoreCase("larger");
        }
        return false;
    }

    private float calculateInternal(LexicalUnit lu, Styles parentStyles, Styles styles) {
        DisplayDevice device = DisplayDevice.getCurrent();
        float baseFontSize = 12.0f * (float)device.getVerticalPPI() / 72.0f;
        if (parentStyles != null) {
            baseFontSize = parentStyles.getFontSize();
        }
        if (lu == null) {
            return baseFontSize;
        }
        if (FontSizeProperty.isLength(lu)) {
            return FontSizeProperty.getFloatLength(lu, baseFontSize, device.getVerticalPPI());
        }
        if (FontSizeProperty.isPercentage(lu)) {
            return baseFontSize * lu.getFloatValue() / 100.0f;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            if (s.equalsIgnoreCase("xx-small")) {
                return baseFontSize * 0.57870364f;
            }
            if (s.equalsIgnoreCase("x-small")) {
                return baseFontSize * 0.6944444f;
            }
            if (s.equalsIgnoreCase("small")) {
                return baseFontSize * 0.8333333f;
            }
            if (s.equalsIgnoreCase("medium")) {
                return baseFontSize * 1.0f;
            }
            if (s.equalsIgnoreCase("large")) {
                return baseFontSize * 1.2f;
            }
            if (s.equalsIgnoreCase("x-large")) {
                return baseFontSize * 1.44f;
            }
            if (s.equalsIgnoreCase("xx-large")) {
                return baseFontSize * 1.7280002f;
            }
            if (s.equalsIgnoreCase("smaller")) {
                return baseFontSize / 1.2f;
            }
            if (s.equalsIgnoreCase("larger")) {
                return baseFontSize * 1.2f;
            }
            return baseFontSize;
        }
        return baseFontSize;
    }
}

