/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.core.Caret;
import net.sf.vex.core.IntRange;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.CompositeInlineBox;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LineBox;

public class ParagraphBox
extends AbstractBox
implements BlockBox {
    private LineBox[] children;
    private LineBox firstContentLine;
    private LineBox lastContentLine;

    private ParagraphBox(LineBox[] children) {
        this.children = children;
        int i = 0;
        while (i < children.length) {
            if (children[i].hasContent()) {
                if (this.firstContentLine == null) {
                    this.firstContentLine = children[i];
                }
                this.lastContentLine = children[i];
            }
            ++i;
        }
    }

    public static ParagraphBox create(LayoutContext context, IVexElement element, List inlines, int width) {
        InlineBox[] array = inlines.toArray(new InlineBox[inlines.size()]);
        return ParagraphBox.create(context, element, array, width);
    }

    public static ParagraphBox create(LayoutContext context, IVexElement element, InlineBox[] inlines, int width) {
        ArrayList<InlineBox> lines = new ArrayList<InlineBox>();
        InlineBox right = new LineBox(context, element, inlines);
        while (right != null) {
            InlineBox.Pair pair = right.split(context, width, true);
            lines.add(pair.getLeft());
            right = pair.getRight();
        }
        Styles styles = context.getStyleSheet().getStyles(element);
        String textAlign = styles.getTextAlign();
        int y = 0;
        int actualWidth = 0;
        for (LineBox lineBox : lines) {
            int x = textAlign.equalsIgnoreCase("right") ? width - lineBox.getWidth() : (textAlign.equalsIgnoreCase("center") ? (width - lineBox.getWidth()) / 2 : 0);
            lineBox.setX(x);
            lineBox.setY(y);
            y += lineBox.getHeight();
            actualWidth = Math.max(actualWidth, lineBox.getWidth());
        }
        LineBox[] children = lines.toArray(new LineBox[lines.size()]);
        ParagraphBox paragraphBox = new ParagraphBox(children);
        paragraphBox.setWidth(actualWidth);
        paragraphBox.setHeight(y);
        return paragraphBox;
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        LineBox line = this.getLineAt(offset);
        Caret caret = line.getCaret(context, offset);
        caret.translate(line.getX(), line.getY());
        return caret;
    }

    @Override
    public Box[] getChildren() {
        return this.children;
    }

    @Override
    public int getEndOffset() {
        return this.lastContentLine.getEndOffset();
    }

    @Override
    public LineBox getFirstLine() {
        if (this.children.length == 0) {
            return null;
        }
        return this.children[0];
    }

    @Override
    public LineBox getLastLine() {
        if (this.children.length == 0) {
            return null;
        }
        return this.children[this.children.length - 1];
    }

    public LineBox getLineAt(int offset) {
        LineBox[] children = this.children;
        int i = 0;
        while (i < children.length) {
            if (children[i].hasContent() && offset <= children[i].getEndOffset()) {
                return children[i];
            }
            ++i;
        }
        return this.lastContentLine;
    }

    @Override
    public int getLineEndOffset(int offset) {
        return this.getLineAt(offset).getEndOffset();
    }

    @Override
    public int getLineStartOffset(int offset) {
        return this.getLineAt(offset).getStartOffset();
    }

    @Override
    public int getMarginBottom() {
        return 0;
    }

    @Override
    public int getMarginTop() {
        return 0;
    }

    @Override
    public int getNextLineOffset(LayoutContext context, int offset, int x) {
        AbstractBox nextLine = null;
        LineBox[] children = this.children;
        int i = 0;
        while (i < children.length) {
            if (children[i].hasContent() && children[i].getStartOffset() > offset) {
                nextLine = children[i];
                break;
            }
            ++i;
        }
        if (nextLine == null) {
            return -1;
        }
        return ((CompositeInlineBox)nextLine).viewToModel(context, x - nextLine.getX(), 0);
    }

    @Override
    public BlockBox getParent() {
        throw new IllegalStateException("ParagraphBox does not currently track parent");
    }

    @Override
    public int getPreviousLineOffset(LayoutContext context, int offset, int x) {
        AbstractBox prevLine = null;
        LineBox[] children = this.children;
        int i = children.length - 1;
        while (i >= 0) {
            if (children[i].hasContent() && children[i].getEndOffset() < offset) {
                prevLine = children[i];
                break;
            }
            --i;
        }
        if (prevLine == null) {
            return -1;
        }
        return ((CompositeInlineBox)prevLine).viewToModel(context, x - prevLine.getX(), 0);
    }

    @Override
    public int getStartOffset() {
        return this.firstContentLine.getStartOffset();
    }

    @Override
    public boolean hasContent() {
        return this.firstContentLine != null;
    }

    @Override
    public IntRange layout(LayoutContext context, int top, int bottom) {
        return null;
    }

    @Override
    public void invalidate(boolean direct) {
        throw new IllegalStateException("invalidate called on a non-element BlockBox");
    }

    @Override
    public void setInitialSize(LayoutContext context) {
    }

    public String toString() {
        return "ParagraphBox";
    }

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        LineBox[] children = this.children;
        int i = 0;
        while (i < children.length) {
            LineBox child = children[i];
            if (child.hasContent() && y <= child.getY() + child.getHeight()) {
                return child.viewToModel(context, x - child.getX(), y - child.getY());
            }
            ++i;
        }
        throw new RuntimeException("No line at (" + x + ", " + y + ")");
    }

    @Override
    public void setParent(BlockBox parent) {
    }
}

