/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.Caret;
import net.sf.vex.core.Insets;
import net.sf.vex.core.IntRange;
import net.sf.vex.core.Rectangle;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.BlockElementBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LineBox;
import net.sf.vex.widget.IVexWidget;

public class RootBox
extends AbstractBox
implements BlockBox {
    private IVexElement element;
    private BlockElementBox childBox;
    private Box[] children = new Box[1];
    private IVexWidget vexWidget;

    public RootBox(LayoutContext context, IVexElement element, int width, IVexWidget vexWidget) {
        this.element = element;
        this.setWidth(width);
        this.childBox = new BlockElementBox(context, this, this.element);
        Insets insets = this.getInsets(context, this.getWidth());
        this.childBox.setX(insets.getLeft());
        this.childBox.setY(insets.getTop());
        this.childBox.setInitialSize(context);
        this.children[0] = this.childBox;
        this.vexWidget = vexWidget;
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        Caret caret = this.childBox.getCaret(context, offset);
        caret.translate(this.childBox.getX(), this.childBox.getY());
        return caret;
    }

    @Override
    public Box[] getChildren() {
        return this.children;
    }

    @Override
    public IVexElement getElement() {
        return this.element;
    }

    @Override
    public int getEndOffset() {
        return this.childBox.getEndOffset();
    }

    @Override
    public LineBox getFirstLine() {
        return this.childBox.getFirstLine();
    }

    @Override
    public LineBox getLastLine() {
        return this.childBox.getLastLine();
    }

    @Override
    public int getLineEndOffset(int offset) {
        return this.childBox.getLineEndOffset(offset);
    }

    @Override
    public int getLineStartOffset(int offset) {
        return this.childBox.getLineStartOffset(offset);
    }

    @Override
    public int getMarginBottom() {
        return 0;
    }

    @Override
    public int getMarginTop() {
        return 0;
    }

    @Override
    public int getNextLineOffset(LayoutContext context, int offset, int x) {
        return this.childBox.getNextLineOffset(context, offset, x - this.childBox.getX());
    }

    @Override
    public BlockBox getParent() {
        throw new IllegalStateException("RootBox does not have a parent");
    }

    @Override
    public int getPreviousLineOffset(LayoutContext context, int offset, int x) {
        return this.childBox.getPreviousLineOffset(context, offset, x - this.childBox.getX());
    }

    @Override
    public int getStartOffset() {
        return this.childBox.getStartOffset();
    }

    @Override
    public void invalidate(boolean direct) {
    }

    @Override
    public IntRange layout(LayoutContext context, int top, int bottom) {
        Insets insets = this.getInsets(context, this.getWidth());
        long start = System.currentTimeMillis();
        IntRange repaintRange = this.childBox.layout(context, top - insets.getTop(), bottom - insets.getBottom());
        long end = System.currentTimeMillis();
        if (end - start > 50L) {
            System.out.println("RootBox.layout took " + (end - start) + "ms");
        }
        this.setHeight(this.childBox.getHeight() + insets.getTop() + insets.getBottom());
        if (repaintRange != null) {
            return new IntRange(repaintRange.getStart() + this.childBox.getY(), repaintRange.getEnd() + this.childBox.getY());
        }
        return null;
    }

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        return this.childBox.viewToModel(context, x - this.childBox.getX(), y - this.childBox.getY());
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        context.getGraphics().getClipBounds();
        super.paint(context, x, y, area);
    }

    @Override
    public void setInitialSize(LayoutContext context) {
        throw new IllegalStateException();
    }

    @Override
    public void setParent(BlockBox parent) {
    }

    public IVexWidget getVexWidget() {
        return this.vexWidget;
    }
}

