/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.vex.core.Insets;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.ElementOrRangeCallback;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.TableRowBox;

public class TableRowGroupBox
extends AbstractBlockBox {
    private static Set childDisplayStyles = new HashSet();

    static {
        childDisplayStyles.add("table-row");
    }

    public TableRowGroupBox(LayoutContext context, BlockBox parent, IVexElement element) {
        super(context, parent, element);
    }

    public TableRowGroupBox(LayoutContext context, BlockBox parent, int startOffset, int endOffset) {
        super(context, parent, startOffset, endOffset);
    }

    @Override
    protected List createChildren(final LayoutContext context) {
        final ArrayList children = new ArrayList();
        this.iterateChildrenByDisplayStyle(context.getStyleSheet(), childDisplayStyles, new ElementOrRangeCallback(){

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                children.add(new TableRowBox(context, TableRowGroupBox.this, child));
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                children.add(new TableRowBox(context, TableRowGroupBox.this, startOffset, endOffset));
            }
        });
        return children;
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        return Insets.ZERO_INSETS;
    }

    @Override
    public int getMarginBottom() {
        return 0;
    }

    @Override
    public int getMarginTop() {
        return 0;
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        if (this.skipPaint(context, x, y)) {
            return;
        }
        this.paintChildren(context, x, y, area);
        if (this.getElement() != null && context.showBlockMarkers()) {
            this.paintMarkerFrame(context, x, y, this.getParent().getWidth());
        }
    }

    @Override
    protected int positionChildren(LayoutContext context) {
        int spacing;
        Styles styles = context.getStyleSheet().getStyles(this.findContainingElement());
        int childY = spacing = styles.getBorderSpacing().getVertical();
        int i = 0;
        while (i < this.getChildren().length) {
            TableRowBox child = (TableRowBox)this.getChildren()[i];
            Insets insets = child.getInsets(context, this.getWidth());
            child.setX(insets.getLeft());
            child.setY(childY += insets.getTop());
            childY += child.getHeight() + insets.getBottom() + spacing;
            ++i;
        }
        this.setHeight(childY);
        return -1;
    }
}

