/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.swt;

import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.action.AbstractVexAction;
import net.sf.vex.action.DuplicateSelectionAction;
import net.sf.vex.action.IVexAction;
import net.sf.vex.action.NextTableCellAction;
import net.sf.vex.action.PreviousTableCellAction;
import net.sf.vex.action.RemoveElementAction;
import net.sf.vex.action.SplitAction;
import net.sf.vex.action.SplitItemAction;
import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.DisplayDevice;
import net.sf.vex.core.EditorOptions;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.impl.Element;
import net.sf.vex.dom.impl.WrongModelException;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.BoxAndOffset;
import net.sf.vex.layout.BoxFactory;
import net.sf.vex.layout.Clickable;
import net.sf.vex.layout.VexAnnotationTracker;
import net.sf.vex.swt.DocumentFragmentTransfer;
import net.sf.vex.swt.KeyStroke;
import net.sf.vex.swt.SwtDisplayDevice;
import net.sf.vex.swt.SwtGraphics;
import net.sf.vex.swt.TextSelectionVex;
import net.sf.vex.swt.Timer;
import net.sf.vex.widget.HostComponent;
import net.sf.vex.widget.IBoxFilter;
import net.sf.vex.widget.IVexWidget;
import net.sf.vex.widget.VexWidgetImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.PopupList;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.xml.sax.SAXException;

public class VexWidget
extends Canvas
implements IVexWidget,
ISelectionProvider {
    private static final char CHAR_NONE = '\u0000';
    private static Map<KeyStroke, IVexAction> keyMap;
    private VexWidgetImpl impl;
    int originX = 0;
    int originY = 0;
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private ISelection selection;
    private ITextSelection textSelection;
    private Runnable caretTimerRunnable = new Runnable(){

        @Override
        public void run() {
            VexWidget.this.impl.toggleCaret();
        }
    };
    private Timer caretTimer = new Timer(500, this.caretTimerRunnable);
    private ControlListener controlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            org.eclipse.swt.graphics.Rectangle r = VexWidget.this.getClientArea();
            if (r.width == 1) {
                return;
            }
            VexWidget.this.impl.setLayoutWidth(r.width);
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                vbar.setThumb(r.height);
                vbar.setPageIncrement(Math.round((float)r.height * 0.9f));
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            VexWidget.this.impl.setFocus(true);
            VexWidget.this.caretTimer.start();
        }

        public void focusLost(FocusEvent e) {
            VexWidget.this.impl.setFocus(false);
            VexWidget.this.caretTimer.stop();
        }
    };
    private HostComponent hostComponent = new HostComponent(){

        @Override
        public Graphics createDefaultGraphics() {
            if (VexWidget.this.isDisposed()) {
                VexToolkitPlugin.log(4, new Exception("Stack trace delivery service"), "*** Woot! VexWidget is disposed!", new Object[0]);
            }
            return new SwtGraphics(new GC((Drawable)VexWidget.this));
        }

        @Override
        public void fireSelectionChanged() {
            if (VexWidget.this.hasSelection()) {
                Object[] nodes = VexWidget.this.getDocument().getNodes(VexWidget.this.getSelectionStart(), VexWidget.this.getSelectionEnd());
                VexWidget.this.selection = (ISelection)new StructuredSelection(nodes);
                VexWidget.this.textSelection = new TextSelectionVex(VexWidget.this, VexWidget.this.getSelectionStart(), VexWidget.this.getSelectionEnd() - VexWidget.this.getSelectionStart(), VexWidget.this.getSelectedText(), (IVexNode[])nodes);
            } else {
                if (VexWidget.this.getCurrentElement() != null) {
                    VexWidget.this.selection = (ISelection)new StructuredSelection((Object)VexWidget.this.getCurrentElement());
                }
                VexWidget.this.textSelection = new TextSelectionVex(VexWidget.this, VexWidget.this.getSelectionStart(), VexWidget.this.getCurrentNode());
            }
            SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)VexWidget.this, VexWidget.this.selection);
            SelectionChangedEvent te = new SelectionChangedEvent((ISelectionProvider)VexWidget.this, (ISelection)VexWidget.this.textSelection);
            int i = 0;
            while (i < VexWidget.this.selectionListeners.size()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)VexWidget.this.selectionListeners.get(i);
                if (VexWidget.this.selection != null) {
                    listener.selectionChanged(e);
                }
                listener.selectionChanged(te);
                ++i;
            }
            VexWidget.this.caretTimer.reset();
        }

        @Override
        public Rectangle getViewport() {
            return new Rectangle(VexWidget.this.getClientArea().x - VexWidget.this.originX, VexWidget.this.getClientArea().y - VexWidget.this.originY, VexWidget.this.getClientArea().width, VexWidget.this.getClientArea().height);
        }

        @Override
        public void invokeLater(Runnable runnable) {
            VexWidget.this.getDisplay().asyncExec(runnable);
        }

        @Override
        public void repaint() {
            if (!VexWidget.this.isDisposed()) {
                VexWidget.this.redraw();
            }
        }

        @Override
        public void repaint(int x, int y, int width, int height) {
            VexWidget.this.redraw(x + VexWidget.this.originX, y + VexWidget.this.originY, width, height, true);
        }

        @Override
        public void scrollTo(int left, int top) {
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                vbar.setSelection(top);
            }
            VexWidget.this.setOrigin(-left, -top);
        }

        @Override
        public void setPreferredSize(int width, int height) {
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                vbar.setMaximum(height);
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            KeyStroke keyStroke = new KeyStroke(e);
            Map map = VexWidget.getKeyMap();
            if (map.containsKey(keyStroke)) {
                Object action = map.get(keyStroke);
                if (action instanceof IVexAction) {
                    ((IVexAction)action).run(VexWidget.this);
                } else {
                    try {
                        ((Action)map.get(keyStroke)).runEx(VexWidget.this);
                    }
                    catch (Exception ex) {
                        VexToolkitPlugin.log(4, ex, "Error running {0} for key event {2}: {1}", this, ex, e);
                    }
                }
            } else if (!Character.isISOControl(e.character)) {
                try {
                    VexWidget.this.insertChar(e.character);
                }
                catch (DocumentValidationException e1) {
                    VexToolkitPlugin.log(4, e1, "Inserting {0} caused a validation exception.", Character.valueOf(e.character));
                }
            } else {
                VexToolkitPlugin.log(2, null, "I don't know what to do with the keystroke {0}", keyStroke);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                VexWidget.this.selectWord();
            }
        }

        public void mouseDown(MouseEvent e) {
            int mouseX = e.x - VexWidget.this.originX;
            int mouseY = e.y - VexWidget.this.originY;
            BoxAndOffset b = VexWidget.this.impl.getBoxAt(mouseX, mouseY);
            if (b != null && b.box instanceof Clickable) {
                ((Clickable)((Object)b.box)).click(mouseX - b.x, mouseY - b.y);
            } else if (e.button == 1) {
                int offset = VexWidget.this.viewToModel(mouseX, mouseY);
                boolean select = e.stateMask == 131072;
                VexWidget.this.moveTo(offset, select);
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    private MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if ((e.stateMask & 0x80000) > 0) {
                int offset = VexWidget.this.viewToModel(e.x - VexWidget.this.originX, e.y - VexWidget.this.originY);
                VexWidget.this.moveTo(offset, true);
            }
        }
    };
    private PaintListener painter = new PaintListener(){

        public void paintControl(PaintEvent e) {
            SwtGraphics g = new SwtGraphics(e.gc);
            g.setOrigin(VexWidget.this.originX, VexWidget.this.originY);
            Color bgColor = VexWidget.this.impl.getBackgroundColor();
            if (bgColor == null) {
                bgColor = new Color(255, 255, 255);
            }
            ColorResource color = g.createColor(bgColor);
            ColorResource oldColor = g.setColor(color);
            Rectangle r = g.getClipBounds();
            g.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            g.setColor(oldColor);
            color.dispose();
            VexWidget.this.impl.paint(g, 0, 0);
        }
    };
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ScrollBar vbar = VexWidget.this.getVerticalBar();
            if (vbar != null) {
                int y = -vbar.getSelection();
                VexWidget.this.setOrigin(0, y);
                int rootHeight = VexWidget.this.hostComponent.getViewport().getHeight();
                VexWidget.this.hostComponent.repaint(0, y, VexWidget.this.impl.getLayoutWidth(), rootHeight);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public VexWidget(Composite parent, int style) {
        super(parent, style);
        if (DisplayDevice.getCurrent() == null) {
            DisplayDevice.setCurrent(new SwtDisplayDevice());
        }
        this.impl = new VexWidgetImpl(this.hostComponent);
        this.setBackground(this.getDisplay().getSystemColor(1));
        ScrollBar vbar = this.getVerticalBar();
        if (vbar != null) {
            vbar.setIncrement(20);
            vbar.addSelectionListener(this.selectionListener);
        }
        this.addControlListener(this.controlListener);
        this.addFocusListener(this.focusListener);
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMoveListener(this.mouseMoveListener);
        this.addPaintListener(this.painter);
    }

    public void dispose() {
        super.dispose();
        this.impl.setFocus(false);
    }

    public Object getInput() {
        return this.impl.getDocument();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new RuntimeException("Unexpected call to setSelection");
    }

    @Override
    public void beginWork() {
        this.impl.beginWork();
    }

    @Override
    public boolean canPaste() {
        return false;
    }

    @Override
    public boolean canPasteText() {
        return false;
    }

    @Override
    public boolean canRedo() {
        return this.impl.canRedo();
    }

    @Override
    public boolean canUndo() {
        return this.impl.canUndo();
    }

    @Override
    public boolean canUnwrap() {
        return this.impl.canUnwrap();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        org.eclipse.swt.graphics.Rectangle r = this.getClientArea();
        int height = r.height;
        ScrollBar vbar = this.getVerticalBar();
        if (vbar != null) {
            height = vbar.getMaximum();
        }
        return new Point(r.width, height);
    }

    @Override
    public void copySelection() {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        Object[] data = new Object[]{this.getSelectedFragment(), this.getSelectedText()};
        Transfer[] transfers = new Transfer[]{DocumentFragmentTransfer.getInstance(), TextTransfer.getInstance()};
        clipboard.setContents(data, transfers);
    }

    @Override
    public void cutSelection() {
        this.copySelection();
        this.deleteSelection();
    }

    @Override
    public void deleteNextChar() throws DocumentValidationException {
        this.impl.deleteNextChar();
    }

    @Override
    public void deletePreviousChar() throws DocumentValidationException {
        this.impl.deletePreviousChar();
    }

    @Override
    public void deleteSelection() {
        this.impl.deleteSelection();
    }

    @Override
    public void doWork(Runnable runnable) {
        this.impl.doWork(runnable);
    }

    @Override
    public void doWork(boolean savePosition, Runnable runnable) {
        this.impl.doWork(savePosition, runnable);
    }

    @Override
    public void endWork(boolean success) {
        this.impl.endWork(success);
    }

    @Override
    public Box findInnermostBox(IBoxFilter filter) {
        return this.impl.findInnermostBox(filter);
    }

    @Override
    public BoxFactory getBoxFactory() {
        return this.impl.getBoxFactory();
    }

    @Override
    public int getCaretOffset() {
        return this.impl.getCaretOffset();
    }

    @Override
    public IVexElement getCurrentElement() {
        return this.impl.getCurrentElement();
    }

    @Override
    public IVexNode getCurrentNode() {
        return this.impl.getCurrentNode();
    }

    @Override
    public IVexDocument getDocument() {
        return this.impl.getDocument();
    }

    @Override
    public int getLayoutWidth() {
        return this.impl.getLayoutWidth();
    }

    @Override
    public int getSelectionEnd() {
        return this.impl.getSelectionEnd();
    }

    @Override
    public int getSelectionStart() {
        return this.impl.getSelectionStart();
    }

    @Override
    public IVexDocumentFragment getSelectedFragment() {
        return this.impl.getSelectedFragment();
    }

    @Override
    public String getSelectedText() {
        return this.impl.getSelectedText();
    }

    @Override
    public StyleSheet getStyleSheet() {
        return this.impl.getStyleSheet();
    }

    @Override
    public int getUndoDepth() {
        return this.impl.getUndoDepth();
    }

    @Override
    public String[] getValidInsertElements() {
        return this.impl.getValidInsertElements();
    }

    @Override
    public String[] getValidMorphElements() {
        return this.impl.getValidMorphElements();
    }

    @Override
    public boolean hasSelection() {
        return this.impl.hasSelection();
    }

    public ITextSelection getTextSelection() {
        return this.textSelection;
    }

    @Override
    public void insertChar(char c) throws DocumentValidationException {
        this.impl.insertChar(c);
    }

    @Override
    public void insertFragment(IVexDocumentFragment frag) throws DocumentValidationException {
        this.impl.insertFragment(frag);
    }

    @Override
    public void insertElement(IVexElement element) throws DocumentValidationException {
        this.impl.insertElement(element);
    }

    @Override
    public void insertText(String text) throws DocumentValidationException {
        this.impl.insertText(text);
    }

    @Override
    public boolean isDebugging() {
        return this.impl.isDebugging();
    }

    @Override
    public void morph(IVexElement element) throws DocumentValidationException {
        this.impl.morph(element);
    }

    @Override
    public void moveBy(int distance) {
        this.impl.moveBy(distance);
    }

    @Override
    public void moveBy(int distance, boolean select) {
        this.impl.moveBy(distance, select);
    }

    @Override
    public void moveTo(int offset) {
        this.impl.moveTo(offset);
    }

    @Override
    public void moveTo(int offset, boolean select) {
        this.impl.moveTo(offset, select);
    }

    @Override
    public void moveToLineEnd(boolean select) {
        this.impl.moveToLineEnd(select);
    }

    @Override
    public void moveToLineStart(boolean select) {
        this.impl.moveToLineStart(select);
    }

    @Override
    public void moveToNextLine(boolean select) {
        this.impl.moveToNextLine(select);
    }

    @Override
    public void moveToNextPage(boolean select) {
        this.impl.moveToNextPage(select);
    }

    @Override
    public void moveToNextWord(boolean select) {
        this.impl.moveToNextWord(select);
    }

    @Override
    public void moveToPreviousLine(boolean select) {
        this.impl.moveToPreviousLine(select);
    }

    @Override
    public void moveToPreviousPage(boolean select) {
        this.impl.moveToPreviousPage(select);
    }

    @Override
    public void moveToPreviousWord(boolean select) {
        this.impl.moveToPreviousWord(select);
    }

    public IAction[] getValidInsertActions() {
        this.isLinked();
        String[] names = this.getValidInsertElements();
        IAction[] actions = new IAction[names.length];
        int i = 0;
        while (i < names.length) {
            actions[i] = new InsertElementAction(names[i]);
            ++i;
        }
        return actions;
    }

    protected boolean isLinked() {
        return this.getDocument() != null && this.getDocument() instanceof LinkedDocument;
    }

    public IAction[] getValidMorphActions() {
        String[] names = this.getValidMorphElements();
        IAction[] actions = new IAction[names.length];
        int i = 0;
        while (i < names.length) {
            actions[i] = new MorphElementAction(names[i]);
            ++i;
        }
        return actions;
    }

    @Override
    public void paste() throws DocumentValidationException {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        IVexDocumentFragment frag = (IVexDocumentFragment)clipboard.getContents((Transfer)DocumentFragmentTransfer.getInstance());
        if (frag != null) {
            this.insertFragment(frag);
        } else {
            this.pasteText();
        }
    }

    @Override
    public void pasteText() throws DocumentValidationException {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (text != null) {
            this.insertText(text);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.impl.redo();
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.impl.removeAttribute(attributeName);
    }

    @Override
    public void savePosition(Runnable runnable) {
        this.impl.savePosition(runnable);
    }

    @Override
    public void selectAll() {
        this.impl.selectAll();
    }

    @Override
    public void selectWord() {
        this.impl.selectWord();
    }

    @Override
    public void setAttribute(String attributeName, String value) {
        this.impl.setAttribute(attributeName, value);
    }

    @Override
    public void setBoxFactory(BoxFactory boxFactory) {
        this.impl.setBoxFactory(boxFactory);
    }

    @Override
    public void setDebugging(boolean debugging) {
        this.impl.setDebugging(debugging);
    }

    @Override
    public void setDocument(IVexDocument doc, StyleSheet styleSheet) {
        this.impl.setDocument(doc, styleSheet);
    }

    @Override
    public void setDocument(URL docUrl, URL ssURL) throws IOException, ParserConfigurationException, SAXException {
        this.impl.setDocument(docUrl, ssURL);
    }

    @Override
    public void setLayoutWidth(int width) {
        this.impl.setLayoutWidth(width);
    }

    @Override
    public void setStyleSheet(StyleSheet styleSheet) {
        this.impl.setStyleSheet(styleSheet);
    }

    @Override
    public void setStyleSheet(URL ssUrl) throws IOException {
        this.impl.setStyleSheet(ssUrl);
    }

    public void showInsertElementPopup() {
        if (this.isLinked()) {
            new net.sf.vex.action.linked.InsertElementAction().run(this);
        } else {
            PopupList list = new PopupList(this.getShell());
            list.setItems(this.getValidInsertElements());
            Rectangle caret = this.impl.getCaret().getBounds();
            Point display = this.toDisplay(caret.getX() + 10, caret.getY());
            String selected = list.open(new org.eclipse.swt.graphics.Rectangle(display.x, display.y, 200, 0));
            if (selected != null) {
                try {
                    this.insertElement(new Element(selected));
                }
                catch (DocumentValidationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void showMorphElementPopup() {
        PopupList list = new PopupList(this.getShell());
        list.setItems(this.getValidMorphElements());
        Rectangle caret = this.impl.getCaret().getBounds();
        Point display = this.toDisplay(caret.getX() + 10, caret.getY());
        String selected = list.open(new org.eclipse.swt.graphics.Rectangle(display.x, display.y, 200, 0));
        if (selected != null) {
            try {
                this.morph(new Element(selected));
            }
            catch (DocumentValidationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void split() throws DocumentValidationException {
        this.impl.split();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.impl.undo();
    }

    @Override
    public int viewToModel(int x, int y) {
        return this.impl.viewToModel(x, y);
    }

    private static void addKey(char character, int keyCode, int stateMask, Action action) {
        keyMap.put(new KeyStroke(character, keyCode, stateMask), action);
    }

    private static void addKey(char character, int keyCode, int stateMask, IVexAction action) {
        keyMap.put(new KeyStroke(character, keyCode, stateMask), action);
    }

    private static void buildKeyMap() {
        VexWidget.addKey('\u0000', 0x1000002, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToNextLine(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000002, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToNextLine(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveBy(-1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveBy(-1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 262144, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToPreviousWord(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000003, 393216, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToPreviousWord(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveBy(1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveBy(1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 262144, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToNextWord(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000004, 393216, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToNextWord(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000001, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToPreviousLine(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000001, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToPreviousLine(true);
            }
        });
        VexWidget.addKey('\b', 8, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) throws Exception {
                w.deletePreviousChar();
            }
        });
        VexWidget.addKey('\u007f', 127, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) throws Exception {
                w.deleteNextChar();
            }
        });
        VexWidget.addKey('\t', 9, 0, new NextTableCellAction());
        VexWidget.addKey('\t', 9, 131072, new PreviousTableCellAction());
        VexWidget.addKey('\u0000', 0x1000008, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToLineEnd(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000008, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToLineEnd(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000008, 262144, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveTo(w.getDocument().getLength() - 1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000008, 393216, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveTo(w.getDocument().getLength() - 1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToLineStart(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToLineStart(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 262144, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveTo(1);
            }
        });
        VexWidget.addKey('\u0000', 0x1000007, 393216, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveTo(1, true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000006, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToNextPage(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000006, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToNextPage(true);
            }
        });
        VexWidget.addKey('\u0000', 0x1000005, 0, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToPreviousPage(false);
            }
        });
        VexWidget.addKey('\u0000', 0x1000005, 131072, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                w.moveToPreviousPage(true);
            }
        });
        Action showInsertElementPopupAction = new Action(){

            @Override
            public void runEx(IVexWidget w) {
                ((VexWidget)w).showInsertElementPopup();
            }
        };
        VexWidget.addKey(' ', 32, 262144, showInsertElementPopupAction);
        VexWidget.addKey('\u0000', 0x1000009, 0, showInsertElementPopupAction);
        VexWidget.addKey('\r', 109, 262144, new Action(){

            @Override
            public void runEx(IVexWidget w) {
                ((VexWidget)w).showMorphElementPopup();
            }
        });
        VexWidget.addKey('\u0017', 0, 262144, new RemoveElementAction());
        VexWidget.addKey('\r', 13, 0, new SplitAction());
        VexWidget.addKey('\r', 13, 131072, new SplitItemAction());
        VexWidget.addKey('\u0004', 100, 262144, new DuplicateSelectionAction());
    }

    private static Map<KeyStroke, IVexAction> getKeyMap() {
        if (keyMap == null) {
            keyMap = new HashMap<KeyStroke, IVexAction>();
            VexWidget.buildKeyMap();
        }
        return keyMap;
    }

    private void setOrigin(int x, int y) {
        int destX = x - this.originX;
        int destY = y - this.originY;
        org.eclipse.swt.graphics.Rectangle ca = this.getClientArea();
        this.scroll(destX, destY, 0, 0, ca.width, ca.height, false);
        this.originX = x;
        this.originY = y;
    }

    @Override
    public void reLayout() {
        this.impl.reLayout();
    }

    @Override
    public BoxAndOffset getBoxAt(int x, int y) {
        return this.impl.getBoxAt(x, y);
    }

    @Override
    public EditorOptions getEditorOptions() {
        return this.impl.getEditorOptions();
    }

    @Override
    public void selectSourceRegion(IRegion region) {
        if (!(this.getDocument() instanceof LinkedDocument)) {
            WrongModelException.throwIfNeeded(this.getDocument(), LinkedDocument.class);
        }
        IRegion contentRegion = ((LinkedDocument)this.getDocument()).contentRegionFor(region);
        this.moveTo(contentRegion.getOffset());
        this.moveBy(Math.min(contentRegion.getLength(), this.getDocument().getLength() - contentRegion.getOffset() - 1), true);
    }

    public void selectDOMNodes(IDOMNode firstNode, IDOMNode lastNode) {
        IVexNode firstVexNode = (IVexNode)AdapterUtils.getAdapter((Object)firstNode, IVexNode.class);
        IVexNode lastVexNode = (IVexNode)AdapterUtils.getAdapter((Object)lastNode, IVexNode.class);
        if (firstVexNode != null && lastVexNode != null) {
            int startOffset = firstVexNode.getStartOffset();
            int endOffset = lastVexNode.getEndOffset();
            this.moveTo(startOffset, false);
            this.moveTo(endOffset, true);
        }
    }

    public void gotoDOMNode(IDOMNode domNode) {
        IVexNode vexNode = (IVexNode)AdapterUtils.getAdapter((Object)domNode, IVexNode.class);
        if (vexNode != null) {
            this.moveTo(vexNode.getStartOffset());
        }
    }

    public void setAnnotationTracker(VexAnnotationTracker tracker) {
        this.impl.setAnnotationTracker(tracker);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.impl.setProgressMonitor(monitor);
    }

    private static abstract class Action
    extends AbstractVexAction {
        private Action() {
        }

        @Override
        public void run(IVexWidget vexWidget) {
            try {
                this.runEx(vexWidget);
            }
            catch (Exception ex) {
                VexToolkitPlugin.log(4, ex, "Error running {0}: {1}", this, ex.getLocalizedMessage());
            }
        }

        public abstract void runEx(IVexWidget var1) throws Exception;
    }

    private class InsertElementAction
    extends org.eclipse.jface.action.Action {
        private String name;

        public InsertElementAction(String name) {
            this.name = name;
            this.setText(name);
        }

        public void run() {
            try {
                VexWidget.this.insertElement(new Element(this.name));
            }
            catch (DocumentValidationException documentValidationException) {}
        }
    }

    private class MorphElementAction
    extends org.eclipse.jface.action.Action {
        private String elementName;

        public MorphElementAction(String elementName) {
            this.elementName = elementName;
            this.setText(elementName);
        }

        public void run() {
            try {
                VexWidget.this.morph(new Element(this.elementName));
            }
            catch (DocumentValidationException e) {
                e.printStackTrace();
            }
        }
    }
}

