/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout.utils;

import org.eclipse.swt.SWT;

public class ConvertHelper {
    public static String convertToString(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static boolean convertToBoolean(String value, boolean defaultValue) {
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if ("true".equals(value) || "yes".equals(value)) {
            return true;
        }
        return Integer.parseInt(value) > 0;
    }

    public static int convertToInteger(String value, int defaultValue) {
        int intValue = defaultValue;
        if (value != null && !"".equals(value)) {
            intValue = Integer.parseInt(value);
        }
        return intValue;
    }

    public static int convertToSWTStyle(String value, int defaultValue) {
        try {
            return SWT.class.getField(value).getInt(null);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int convertToSWTAlignment(String align) {
        if ("left".equals(align)) {
            return 1;
        }
        if ("right".equals(align)) {
            return 131072;
        }
        if ("center".equals(align)) {
            return 0x1000000;
        }
        if ("middle".equals(align)) {
            return 0x1000000;
        }
        if ("top".equals(align)) {
            return 1;
        }
        if ("bottom".equals(align)) {
            return 0x1000008;
        }
        return 1;
    }
}

