/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigPlugin;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.ConfigSource;
import net.sf.vex.editor.config.Messages;
import net.sf.vex.editor.config.PluginProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

public class ConfigLoaderJob
extends Job {
    public static final String PLUGIN_CONFIG_SER_PREFIX = ".vexConfig-";
    public static final String PLUGIN_CONFIG_SER_SUFFIX = ".ser";

    public ConfigLoaderJob() {
        super(Messages.getString("ConfigLoaderJob.loadingConfig"));
    }

    protected IStatus run(IProgressMonitor monitor) {
        int pluginCount = Platform.getExtensionRegistry().getNamespaces().length;
        int projectCount = ResourcesPlugin.getWorkspace().getRoot().getProjects().length;
        monitor.beginTask(Messages.getString("ConfigLoaderJob.loadingConfig"), pluginCount + projectCount);
        this.loadPlugins(monitor);
        this.loadPluginProjects(monitor);
        ConfigRegistry.getInstance().fireConfigLoaded(new ConfigEvent((Object)this));
        monitor.done();
        return Status.OK_STATUS;
    }

    private void loadPlugins(IProgressMonitor monitor) {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        String[] namespaces = extRegistry.getNamespaces();
        int i = 0;
        while (i < namespaces.length) {
            String ns = namespaces[i];
            Bundle bundle = Platform.getBundle((String)ns);
            if (bundle != null) {
                String message;
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                monitor.subTask(String.valueOf(Messages.getString("ConfigLoaderJob.loading")) + name);
                File stateDir = Platform.getStateLocation((Bundle)bundle).toFile();
                String version = (String)bundle.getHeaders().get("Bundle-Version");
                String serFile = PLUGIN_CONFIG_SER_PREFIX + version + PLUGIN_CONFIG_SER_SUFFIX;
                File configSerFile = new File(stateDir, serFile);
                ConfigSource source = null;
                if (configSerFile.exists()) {
                    try {
                        source = ConfigLoaderJob.loadConfigSourceFromFile(configSerFile);
                    }
                    catch (IOException ex) {
                        message = MessageFormat.format(Messages.getString("ConfigLoaderJob.loadingError"), configSerFile);
                        this.log(2, message, ex);
                    }
                }
                if (source == null) {
                    source = ConfigPlugin.load(ns);
                    if (source != null) {
                        try {
                            ConfigLoaderJob.saveConfigSourceToFile(source, configSerFile);
                        }
                        catch (IOException ex) {
                            message = MessageFormat.format(Messages.getString("ConfigLoaderJob.cacheError"), configSerFile);
                            this.log(2, message, ex);
                        }
                    } else if (configSerFile.exists()) {
                        configSerFile.delete();
                    }
                }
                if (source != null) {
                    configRegistry.addConfigSource(source);
                }
                monitor.worked(1);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ConfigSource loadConfigSourceFromFile(File file) throws IOException {
        ConfigSource configSource;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            configSource = (ConfigSource)ois.readObject();
            if (fis == null) return configSource;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new IOException(ex.getMessage());
            }
            catch (Throwable throwable) {
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            fis.close();
            return configSource;
        }
        catch (IOException iOException) {}
        return configSource;
    }

    private static void saveConfigSourceToFile(ConfigSource config, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(config);
        }
        catch (Throwable throwable) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void loadPluginProjects(IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].isOpen() && projects[i].hasNature("net.sf.vex.editor.pluginNature")) {
                    monitor.subTask(String.valueOf(Messages.getString("ConfigLoaderJob.loadingProject")) + projects[i].getName());
                    PluginProject.load(projects[i]);
                    monitor.worked(1);
                }
            }
            catch (CoreException e) {
                String message = MessageFormat.format(Messages.getString("ConfigLoaderJob.natureError"), projects[i].getName());
                VexPlugin.getInstance().log(4, message, e);
            }
            ++i;
        }
    }

    private void log(int severity, String message, Throwable exception) {
        VexPlugin.getInstance().log(severity, message, exception);
    }
}

