/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.BuildProblem;
import net.sf.vex.editor.config.BuildProblemDecorator;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.IBuildProblemHandler;
import net.sf.vex.editor.config.Messages;
import net.sf.vex.editor.config.PluginProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXParseException;

public class PluginProjectBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "net.sf.vex.editor.pluginBuilder";
    private BuildProblemDecorator buildProblemDecorator;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        boolean parseConfigXml;
        IProject project = this.getProject();
        final PluginProject pluginProject = PluginProject.get(project);
        if (pluginProject == null) {
            String message = MessageFormat.format(Messages.getString("PluginProjectBuilder.notConfigSource"), project.getName());
            VexPlugin.getInstance().log(4, message);
            return null;
        }
        IResourceDelta delta = this.getDelta(project);
        if (kind == 6 || delta == null) {
            this.clean(null);
            parseConfigXml = true;
        } else {
            parseConfigXml = delta.findMember((IPath)new Path("vex-plugin.xml")) != null;
            final boolean canUpdateConfig = !parseConfigXml;
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    String path = resource.getProjectRelativePath().toString();
                    pluginProject.removeResource(path);
                    if (delta.getKind() == 2) {
                        String message;
                        ConfigItem item = pluginProject.getItemForResource(path);
                        if (item == null) {
                            return true;
                        }
                        if (canUpdateConfig && (delta.getFlags() & 0x2000) > 0) {
                            String newPath = delta.getMovedToPath().removeFirstSegments(1).toString();
                            item.setResourcePath(newPath);
                        } else {
                            pluginProject.remove(item);
                        }
                        try {
                            pluginProject.writeConfigXml();
                        }
                        catch (Exception ex) {
                            message = MessageFormat.format(Messages.getString("PluginProjectBuilder.cantSaveFile"), "vex-plugin.xml");
                            VexPlugin.getInstance().log(4, message, ex);
                        }
                        try {
                            pluginProject.saveState();
                        }
                        catch (Exception ex) {
                            message = MessageFormat.format(Messages.getString("PluginProjectBuilder.cantSaveFile"), ".vexConfig.ser");
                            VexPlugin.getInstance().log(2, message, ex);
                        }
                    }
                    return true;
                }
            };
            delta.accept(visitor);
        }
        IMarker[] oldMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        IResource[] markedResources = new IResource[oldMarkers.length];
        int i = 0;
        while (i < markedResources.length) {
            markedResources[i] = oldMarkers[i].getResource();
            ++i;
        }
        project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        this.getBuildProblemDecorator().update(markedResources);
        ConfigRegistry registry = ConfigRegistry.getInstance();
        try {
            String message;
            registry.lock();
            if (parseConfigXml) {
                IFile pluginXmlResource = this.getProject().getFile("vex-plugin.xml");
                try {
                    if (pluginXmlResource.exists()) {
                        pluginProject.parseConfigXml();
                    } else {
                        pluginProject.removeAllItems();
                        String message2 = MessageFormat.format(Messages.getString("PluginProjectBuilder.missingFile"), "vex-plugin.xml");
                        this.flagError((IResource)this.getProject(), message2);
                    }
                }
                catch (SAXParseException ex) {
                    this.flagError((IResource)pluginXmlResource, ex.getLocalizedMessage(), ex.getLineNumber());
                }
                catch (Exception ex) {
                    message = MessageFormat.format(Messages.getString("PluginProjectBuilder.parseError"), "vex-plugin.xml");
                    VexPlugin.getInstance().log(4, message, ex);
                    this.flagError((IResource)pluginXmlResource, ex.getLocalizedMessage());
                }
            }
            IBuildProblemHandler problemHandler = new IBuildProblemHandler(){

                @Override
                public void foundProblem(BuildProblem problem) {
                    try {
                        IFile resource = PluginProjectBuilder.this.getProject().getFile(problem.getResourcePath());
                        PluginProjectBuilder.this.flagError((IResource)resource, problem.getMessage(), problem.getLineNumber());
                    }
                    catch (CoreException e) {
                        VexPlugin.getInstance().getLog().log(e.getStatus());
                    }
                }
            };
            pluginProject.parseResources(problemHandler);
            try {
                pluginProject.saveState();
            }
            catch (IOException ex) {
                message = MessageFormat.format(Messages.getString("PluginProjectBuilder.cantSaveConfig"), project.getName());
                VexPlugin.getInstance().log(2, message, ex);
            }
        }
        finally {
            registry.unlock();
        }
        registry.fireConfigChanged(new ConfigEvent((Object)this));
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        ConfigRegistry registry = ConfigRegistry.getInstance();
        try {
            registry.lock();
            PluginProject pluginProject = PluginProject.get(this.getProject());
            if (pluginProject != null) {
                pluginProject.cleanState();
                pluginProject.removeAllItems();
                pluginProject.removeAllResources();
                registry.fireConfigChanged(new ConfigEvent((Object)this));
            }
        }
        finally {
            registry.unlock();
        }
    }

    private void flagError(IResource resource, String message) throws CoreException {
        this.flagError(resource, message, -1);
    }

    private void flagError(IResource resource, String message, int lineNumber) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        if (marker.exists()) {
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("priority", 2);
            marker.setAttribute("severity", 2);
            if (lineNumber > 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            this.getBuildProblemDecorator().update(resource);
        }
    }

    private BuildProblemDecorator getBuildProblemDecorator() {
        if (this.buildProblemDecorator == null) {
            IDecoratorManager dm = PlatformUI.getWorkbench().getDecoratorManager();
            this.buildProblemDecorator = (BuildProblemDecorator)dm.getBaseLabelProvider("net.sf.vex.editor.config.buildProblemDecorator");
        }
        return this.buildProblemDecorator;
    }
}

