/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.dialogs;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.linkeditor.controller.Activator;
import info.textgrid.lab.linkeditor.controller.LinkEditorController;
import info.textgrid.lab.linkeditor.controller.utils.RefersToClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class SelectLinksobjectDialog
extends TrayDialog {
    private LinkEditorController controller = null;
    private String selectedObjectTitle = null;
    private TextGridObject tgObject = null;
    private Map<String, String> uriMap = Collections.synchronizedMap(new HashMap());

    protected SelectLinksobjectDialog(Shell shell) {
        super(shell);
    }

    public static boolean openDialog(final LinkEditorController controller, final TextGridObject tgObject) {
        UIJob dialogJ = new UIJob("Starting the dialog..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SelectLinksobjectDialog dialog = new SelectLinksobjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.controller = controller;
                dialog.tgObject = tgObject;
                if (!dialog.fetchRelations()) {
                    return Status.CANCEL_STATUS;
                }
                dialog.open();
                return Status.OK_STATUS;
            }
        };
        dialogJ.schedule();
        return dialogJ.getResult() == Status.OK_STATUS;
    }

    private boolean fetchRelations() {
        ArrayList<String> uris;
        block6: {
            uris = RefersToClient.getInstance().getRelationURIs(this.tgObject);
            if (uris != null) break block6;
            return false;
        }
        try {
            for (String uri : uris) {
                this.uriMap.put(TextGridObject.getInstance((URI)new URI(uri), (boolean)false).getTitle(), uri);
            }
        }
        catch (CrudServiceException e) {
            Activator.handleError(e);
        }
        catch (CoreException e) {
            Activator.handleError(e);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e);
        }
        return this.uriMap.size() > 0;
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(1, false));
        Label intro = new Label(control, 64);
        intro.setLayoutData((Object)new GridData(4, 128, true, false));
        intro.setText("The selected image is related to these link-object(s).\nYou can select a link-object from the list below!");
        this.createObjectsList(control);
        this.createButtons(control);
        return control;
    }

    private void createObjectsList(Composite control) {
        final List list = new List(control, 0);
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectLinksobjectDialog.this.selectedObjectTitle = list.getItem(list.getSelectionIndex());
            }
        });
        for (String s : this.uriMap.keySet()) {
            list.add(s);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void createButtons(Composite control) {
        Group group = new Group(control, 16);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, true));
        Button ok = new Button((Composite)group, 8);
        ok.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ok.setText("Ok");
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectLinksobjectDialog.this.selectedObjectTitle != null) {
                    SelectLinksobjectDialog.this.updateLinkEditorController();
                    SelectLinksobjectDialog.this.okPressed();
                }
            }
        });
        Button cancel = new Button((Composite)group, 8);
        cancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        cancel.setText("Cancel");
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectLinksobjectDialog.this.controller.updateDataFromSelectLinkobjectDialog(null);
                SelectLinksobjectDialog.this.cancelPressed();
            }
        });
    }

    private void updateLinkEditorController() {
        try {
            this.controller.updateDataFromSelectLinkobjectDialog(TextGridObject.getInstance((URI)new URI(this.uriMap.get(this.selectedObjectTitle)), (boolean)false));
        }
        catch (CrudServiceException e) {
            Activator.handleError(e);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e);
        }
    }
}

